/* autogenerated by Processing revision 1282 on 2022-04-13 */
import processing.core.*;
import processing.data.*;
import processing.event.*;
import processing.opengl.*;

import java.util.*;
import ddf.minim.*;
import java.util.*;

import java.util.HashMap;
import java.util.ArrayList;
import java.io.File;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;

public class Code_1_6_1_technocode_Naomi3 extends PApplet {

  
  //het declareren van de variabelen
  Background background = new Background();
  StartScreen startScreen = new StartScreen();
  GameOverScreen gameOverScreen = new GameOverScreen();
  PauzeScreen pauzeScreen = new PauzeScreen();
  ScoreList highscores = new ScoreList();
  
  Camera worldCamera = new Camera();
  Player player = new Player();
  Restart restart = new Restart();
  Time time = new Time();
  TypeYourName typeyourname = new TypeYourName();
  
  // geeft de gamestates van het spel aan.
  final int START_SCREEN = 0;
  final int PLAYING = 1;
  final int GAME_OVER_LOST = 2;
  final int GAME_OVER_WON = 3;
  final int PAUZE = 4;
  
  int gameState = START_SCREEN;
  
  //Arrays
  Platform[] platforms = new Platform[77];
  Nut[] nuts = new Nut[10];
  Finish[] Finish = new Finish[2];
  Bear[] Bears = new Bear[7];
  Bee[] Bees = new Bee[7];
  
  boolean onFinish = false;
  boolean rotating = false;
  
  int nutsLeft = nuts.length;
  int lvl = 1;
  int lvlSize = 60000;
  
  //het aantal objecten in een Array bepalen
  int nRaindrops = 500;
  int nClouds = 50;
  
  ArrayList<raindrops> Raindrop = new ArrayList<raindrops>();
  ArrayList<Clouds> Cloud = new ArrayList<Clouds>();

  
  SampleBank sampleBank;
  
   public void setup() 
  {
    //Clouds aanmaken
    for (int iCloud = 0; iCloud < nClouds; iCloud ++)
    {
      Clouds aCloud = new Clouds();
      aCloud.init();
      Cloud.add(aCloud);
    }
    //raindrops aanmaken
    for (int iRain = 0; iRain < nRaindrops; iRain ++)
    {
      raindrops aRaindrop = new raindrops();
      aRaindrop.init();
      Raindrop.add(aRaindrop);
    }
  
    pauzeScreen.init();
    startScreen.init();
    gameOverScreen.init();
    /* size commented out by preprocessor */;
    textSize(25);
    gameState = START_SCREEN;
  
    time.setup();
    player.init();
    typeyourname.init();
    restart.init();
  
    sampleBank = new SampleBank();
    sampleBank.loadMusic("bgMusic.mp3");
    sampleBank.playMusic();
    sampleBank.loopMusic();
  
  
    background.init();
    for (int i=0; i<platforms.length; i++)
    platforms[i] = new Platform();
    //Level grond 1
    platforms[0].init(16, 0, height - 70, 3100, 100);
  
    //Eerste blokken en platformen
    platforms[1].init(4, 1500, 295, 200, 500);
    platforms[2].init(14, 2500, 360, 150, 300);
    platforms[3].init(1, 2700, -30, 600, 50);
    platforms[4].init(13, 2350, 550, 150, 100);
  
    //Hogere grond 1
    platforms[5].init(16, 3100, height - 200, 3000, 200);
  
    //Level grond 2
    platforms[75].init(16, 6100, height - 70, 2200, 200);
  
    //Platform met nootje
    platforms[6].init(1, 4400, 200, 600, 50);
  
    //platformen over gat/beer
    platforms[7].init(2, 6300, 250, 200, 50);
    platforms[8].init(2, 6700, 100, 200, 50);
    platforms[9].init(2, 7100, -50, 200, 50);
    platforms[10].init(2, 7500, 100, 200, 50);
    platforms[11].init(2, 7900, 250, 200, 50);
  
    //Hogere grond 2
    platforms[12].init(16, 8300, height - 200, 50000, 200);
  
    //muren om beer en nootje
    platforms[13].init(13, 9500, 420, 150, 100);
    platforms[14].init(14, 9650, 230, 150, 300);
    platforms[15].init(14, 10700, 230, 150, 300);
    platforms[16].init(13, 10850, 420, 150, 100);
  
    //klimpuzzel dinges
    platforms[17].init(1, 11400, -600, 600, 50);
    platforms[18].init(2, 12400, -600, 200, 50);
    platforms[19].init(1, 13000, -600, 600, 50);
    platforms[20].init(2, 12200, 200, 200, 50);
    platforms[21].init(2, 12500, -50, 200, 50);
    platforms[22].init(2, 12800, -300, 200, 50);
    platforms[23].init(13, 12900, 420, 150, 100);
  
    //Platformen met beren ertussen
    platforms[24].init(13, 14000, 420, 150, 100);
    platforms[25].init(14, 14800, 230, 150, 300);
    platforms[26].init(14, 15500, 230, 150, 300);
    platforms[27].init(13, 16900, 420, 150, 100);
  
    //Eind van level
    platforms[28].init(5, 18000, 0, 150, 800);
    platforms[29].init(0, 17000, 800, 150, 800);
  
    //begin lvl 2
    platforms[30].init(16, 20000, -100, 1000, 100);
    platforms[31].init(15, 20800, -500, 200, 600);
  
    //zwevende platformen begin
    platforms[32].init(7, 21400, -500, 300, 50);
    platforms[33].init(7, 22000, -400, 300, 50);
    platforms[34].init(7, 22600, -300, 300, 50);
    platforms[35].init(7, 23000, -700, 300, 50);
    platforms[36].init(7, 23400, -900, 300, 50);
    platforms[37].init(7, 24100, -700, 300, 50);
  
    //2e set
    platforms[38].init(7, 24700, -400, 300, 50);
    platforms[39].init(7, 25400, -700, 300, 50);
    platforms[40].init(7, 25900, -1000, 300, 50);
    platforms[41].init(7, 26200, -500, 300, 50);
    platforms[42].init(7, 26700, -300, 300, 50);
    platforms[43].init(7, 26500, -1400, 300, 50);
  
    //3e set
    platforms[47].init(12, 24600, -2700, 50, 400);
    platforms[44].init(7, 25900, -1700, 300, 50);
    platforms[45].init(7, 25300, -2000, 300, 50);
    platforms[46].init(7, 24600, -2300, 300, 50);
    platforms[48].init(8, 24000, -2710, 600, 50);
    platforms[49].init(9, 23900, -2200, 500, 50);
  
    //4e set
    platforms[50].init(7, 23300, -2500, 300, 50);
    platforms[51].init(7, 22600, -2700, 300, 50);
    platforms[52].init(7, 22000, -3000, 300, 50);
    platforms[53].init(8, 21000, -2660, 600, 50);
    platforms[54].init(7, 22600, -3300, 300, 50);
    platforms[55].init(7, 23200, -3600, 300, 50);
  
    //5e set
    platforms[56].init(7, 23700, -4000, 300, 50);
    platforms[57].init(7, 24400, -3600, 300, 50);
    platforms[58].init(7, 24900, -4000, 300, 50);
    platforms[59].init(7, 25500, -3600, 300, 50);
    platforms[60].init(8, 26200, -3600, 600, 50);
    platforms[61].init(9, 24200, -4300, 500, 50);
  
    //6e set
    platforms[62].init(7, 23600, -4600, 300, 50);
    platforms[63].init(7, 23000, -4900, 300, 50);
    platforms[64].init(7, 22400, -5100, 300, 50);
    platforms[65].init(10, 21700, -5000, 200, 50);
    platforms[66].init(11, 20800, -4800, 400, 50);
    platforms[67].init(9, 23000, -5500, 500, 50);
  
    //7e set
    platforms[68].init(9, 24000, -5650, 500, 50);
    platforms[69].init(9, 25000, -5800, 500, 50);
    platforms[70].init(9, 26000, -5950, 500, 50);
    platforms[71].init(7, 27000, -5600, 300, 50);
    platforms[72].init(7, 27600, -5900, 300, 50);
    platforms[73].init(7, 28200, -5700, 300, 50);
    platforms[74].init(16, 28900, -5700, 2000, 100);
   for (int i = 0 ; i<Bees.length; i++)
   {
     Bees[i] = new Bee();
   }
    Bees[0].init(2000, height-320, 120, 230);
    Bees[1].init(8000, height-320, 120, 230);
    Bees[2].init(6200, height-320, 120, 230);
    Bees[3].init(10150, height-450, 120, 230);
    Bees[4].init(13500, height-450, 120, 230);
    Bees[5].init(15000, height-450, 120, 230);
    Bees[6].init(16000, height-450, 120, 230);
    
   for (int i=0; i< Bears.length; i++)
    Bears[i] = new Bear();
    Bears[0].init(2800, height-320, 120, 230);
    Bears[1].init(8000, height-320, 120, 230);
    Bears[2].init(6200, height-320, 120, 230);
    Bears[3].init(10150, height-450, 120, 230);
    Bears[4].init(13500, height-450, 120, 230);
    Bears[5].init(15000, height-450, 120, 230);
    Bears[6].init(16000, height-450, 120, 230);
  
    // Array voor de nootjes
    if (lvl == 1) 
    {
      for (int i=0; i<nuts.length; i++)
      {
        nuts[i] = new Nut();
      }
      nuts[0].init(1600, 150);
      nuts[1].init(2600, 200);
      nuts[2].init(3600, 350);
      nuts[3].init(4700, 0);
      nuts[4].init(7190, -250);
      nuts[5].init(10500, 350);
      nuts[6].init(11700, -750);
      nuts[7].init(13400, -750);
      nuts[8].init(15580, 50);
      nuts[9].init(17700, 350);
      
    } else 
    {
      //nootjes spawns voor lvl 2
      for (int i=0; i<nuts.length; i++)
      {
       nuts[i] = new Nut();
      }
      nuts[0].init(23150, -900);
      nuts[1].init(26850, -450);
      nuts[2].init(24150, -2400);
      nuts[3].init(21250, -2810);
      nuts[4].init(26500, -3750);
      nuts[5].init(24450, -4450);
      nuts[6].init(21000, -4950);
      nuts[7].init(26650, -1550);
      nuts[8].init(25250, -5750);
      nuts[9].init(29200, -5850);
    }
  
    for (int i=0; i<Finish.length; i++)
    {
       Finish[i] = new Finish();
    }
    Finish[0].init(1, 18000, -100, 100, 100);
    Finish[1].init(1, 29900, -5800, 50, 50);
  }
  
   public void draw() {

    background(0, 210, 255);
    fill(0, 0, 0);

    typeyourname.draw();
    text("Nuts left: "+ nutsLeft, 10, 30);
    
    //Zet de tijd op stop als noten is 0 en je op p drukt.
    if (nutsLeft>0 && gameState != 4) 
    {
      time.update();
    }
  
    if (nutsLeft == 0 && onFinish == true && lvl == 2) 
    {
      if (typeyourname.textbox == 3 || typeyourname.textbox == 4) 
      {
  
  
        for (int iScore=0; iScore<highscores.getScoreCount (); iScore++) 
        {
  
          // only show the top 10 scores
          if (iScore>=9) break;
  
          // fetch a score from the list
          Score score = highscores.getScore(iScore);
  
          // display score in window
          if (keysPressed['S']) 
          {
  
            text("Ranking        Name        Time", 250, 170);
            text("   "+(iScore+1) + "                " + score.name + "          " + score.time + "\n", 250, 200 + iScore*20);
          }
        }
      }
      
      text("  Your Time: " + time.minutes + ":" + time.seconds + "."  + time.tenth + "\n\nPress [R] to Restart\nPress [H] to enter Score", width/2 - 300, height/2-150);
      player.speed = 0;
    }
   
    time.draw();
    //wereld x en y worden de camera x en y
    translate(-worldCamera.pos.x, -worldCamera.pos.y);
  
    //camera en achtergrond tekenen
    worldCamera.draw();
    update();
  }
  
   public void update() 
  {
    for (int iCloud=0; iCloud < Cloud.size (); iCloud++)
    {
      Cloud.get(iCloud).draw();
    }
    for (int iCloud = 0; iCloud < Cloud.size (); iCloud++)
    {
      Clouds aCloud = Cloud.get(iCloud);
      aCloud.update();
    }
    
    background.draw();
  
    for (Finish finish : Finish)
    {
     finish.update();
    }
    //De collision tusen de Finish en de Player
    for (Finish finish : Finish)
    {
     resolvePlayerFinishCollision(finish, player);
    }
    
    for (Nut nut : nuts)
    {
      nut.draw();
    }

    restart.draw();
    background.update();
  
    //Game wordt op pauze gezet als er op 'P' wordt gedrukt
    if (keysPressed['P']) 
    {
      gameState = PAUZE;
    }
  
  
    if (gameState == PLAYING) 
    {
      player.update();
      for (Platform platform : platforms)
        platform.update();
      for (Platform platform : platforms)
        resolvePlayerPlatformCollision(platform, player);
  
      // Check collision met alle nootjes
      for (Nut nut : nuts)
      {
        resolvePlayerNutCollision(nut, player);
      }
     for (int iBee = 0; iBee < Bees.length; iBee++)
     {
       Bees[iBee].draw();
       Bees[iBee].update();
       resolvePlayerEnemyCollision(Bees[iBee], player);
       
       for(int iPlatform = 0; iPlatform < platforms.length; iPlatform++)
       {
         resolvePlatformEnemyCollision(Bees[iBee], platforms[iPlatform]);
       }
     }
     for(int iBear = 0; iBear < Bears.length ; iBear++ )
     {
       Bears[iBear].draw();
       Bears[iBear].update();
       resolvePlayerEnemyCollision(Bears[iBear], player);
       
     for (int iPlatform = 0; iPlatform < platforms.length; iPlatform++ )
      {
        resolvePlatformEnemyCollision(Bears[iBear], platforms[iPlatform]);
      }
     }
      
      for (int iRain = 0; iRain < Raindrop.size (); iRain++)
      {
        raindrops aRaindrop = Raindrop.get(iRain);
        aRaindrop.update();
      }
  
      if (lvl ==1 )
      {
        //regen maken
        for (int iRain=0; iRain < Raindrop.size (); iRain++)
        {
          Raindrop.get(iRain).draw();
        }
      }
    }
  
    fill(0);
    text("Controls: Move with: [W] [A] [S] [D]", 100, 200);
    text("Press [R] to reset", 100, 225);
    text("Press against a wall and hold [W] to climb", 100, 250);
  
  
    if (lvl == 1) 
    {
      if (nutsLeft > 0) 
      {
        text("Collect "+ nutsLeft + " Nuts to continue!", 17900, -300);
      } else 
      {
        text("Press 'S' to continue!", 17900, -300);
      }
    } 
    else 
    {
      if (nutsLeft > 0) 
      {
        text("Collect "+ nutsLeft + " Nuts to continue!", 29800, -6000);
      }
    }
  
    switch (gameState) 
    {
    case START_SCREEN: 
      startScreen.updateAndDraw(); 
      break;
    case PLAYING: 
      break;
    case GAME_OVER_LOST:
      gameOverScreen.updateAndDraw(); 
      break;
    case GAME_OVER_WON: 
      gameOverScreen.updateAndDraw(); 
      break;
  
    case PAUZE:
      pauzeScreen.draw();
      break;
    }
  }
  
  class Background { 
    //declareren van de variabelen
    int x;
    int y;
    int w;
    int h;
    float xCloud1;
    float xCloud2;
    float xCloud3;
  
    PImage flower1;
    PImage flower2;
    PImage flower3;
    PImage flower4;
    PImage flower5;
    PImage bush;
    PImage cloud1;
    PImage cloud2;
    PImage cloud3;
    PImage mushroomRed;
    PImage mushroomBlue;
    PImage mushroomYellow;
    PImage mushroomPink;
    PImage mushroomGreen;
  
  
  
     public void init()
    {
      //initialiseren van de variabelen
      x = 100;
      y = 610;
      w = 90;
      h = 90;
      xCloud1 = 10;
      xCloud2 = 20;
      xCloud3 = 30;
  
      flower1 = loadImage("flower1.png");
      flower2 = loadImage("flower2.png");
      flower3 = loadImage("flower3.png");
      flower4 = loadImage("flower4.png");
      flower5 = loadImage("flower5.png");
      bush = loadImage("struik2.png");
      cloud1 = loadImage("wolk1.png");
      cloud2 = loadImage("wolk2.png");
      cloud3 = loadImage("wolk3.png");
      mushroomRed = loadImage("paddenstoelRood.png");
      mushroomBlue = loadImage("paddenstoelBlauw.png");
      mushroomYellow = loadImage("paddenstoelGeel.png");
      mushroomPink = loadImage("paddenstoelRoze.png");
      mushroomGreen = loadImage("paddenstoelGroen.png");
    }
  
     public void draw()
    {
      //wolken plaatsen
      image(cloud1, xCloud1 - 900, y - 400, w + 100, h +100);
      image(cloud2, xCloud2, y-200, w+150, h + 100); 
      image(cloud1, xCloud2 - 10000, y - 400, w + 10, h + 10);   
      image(cloud1, xCloud2 -400, y - 500, w, h);
      image(cloud1, xCloud2 -100000, y - 500, w, h);
      image(cloud1, xCloud2 - 11100, y - 600, w, h);
      image(cloud1, xCloud3 + 11100, y - 600, w, h);
      image(cloud2, xCloud1 -4000, y - 500, w, h);
      image(cloud2, xCloud1 - 600, y - 300, w, h);
      image(cloud3, xCloud1 - 800, y - 700, w, h);
      image(cloud3, xCloud2 - 20000, y - 700, w + 100, h + 100);
      image(cloud3, xCloud2 + 100000, y - 600, w, h);
      image(cloud3, xCloud1 + 200, y - 400, w + 100, h + 100);
      image(cloud3, xCloud1 + 120000, y - 700, w + 100, h + 100);
  
  
      //bosjes groot plaatsen
      image(bush, x + 200, y - 30, w + 100, h+100);
      image(bush, x + 625, y - 30, w + 100, h + 100);
      image(bush, x + 1800, y - 30, w + 100, h+100); 
      image(bush, x + 2750, y - 30, w + 100, h +100); 
      image(bush, x + 7740, y - 30, w + 100, h + 100);
      image(bush, x + 8385, y - 140, w + 100, h + 100);
      image(bush, x + 4410, y - 130, w + 100, h + 100);
      image(bush, x + 15910, y - 140, w + 100, h + 100);
      image(bush, x + 17380, y - 140, w + 100, h + 100);
      image(bush, x + 11550, y - 140, w + 100, h + 100);
      image(bush, x + 10340, y - 140, w + 100, h + 100);
      image(bush, x + 12610, y - 140, w + 100, h + 100);
      image(bush, x + 9285, y - 140, w + 100, h + 100);
      image(bush, x + 14555, y - 140, w + 100, h + 100);
      image(bush, x + 13290, y - 140, w + 100, h + 100);
  
  
      //bosjes klein plaatsen
      image(bush, x + 1850, y, w + 10, h+10);
      image(bush, x + 3570, y - 130, w + 10, h + 10);
      image(bush, x + 11600, y - 120, w + 10, h + 10);
  
      //bloem roze plaatsen
      image(flower1, x - 50, y, w, h);
      image(flower1, x + 1100, y, w, h);
      image(flower1, x + 3100, y-680, w, h);
      image(flower1, x + 3900, y - 130, w, h);
      image(flower1, x + 6250, y, w, h);
      image(flower1, x + 7105, y - 700, w, h);
  
      //bloem paars plaatsen
      image(flower2, x + 100, y, w, h);
      image(flower2, x + 10000, y, w, h);
      image(flower2, x + 1170, y, w, h);
      image(flower2, x + 2875, y, w, h);
      image(flower2, x + 4410, y - 450, w, h);
      image(flower2, x + 15070, y - 135, w, h);
      image(flower2, x + 13400, y - 135, w, h);
  
      //bloem rood plaatsen 
      image(flower3, x + 2450, y-300, w, h);
      image(flower3, x + 4800, y -130, w, h);
      image(flower3, x + 6665, y-550, w, h);
      image(flower3, x + 10000, y -130, w, h);
  
      //bloem oranje plaatsen
      image(flower4, x + 300, y, w, h);
      image(flower4, x + 2800, y - 680, w, h);
      image(flower4, x + 4300, y -130, w, h);
      image(flower4, x + 9200, y -130, w, h);
      image(flower4, x + 12700, y - 130, w, h);
  
      //bloem blauw plaatsen
      image(flower5, x + 1020, y, w, h);
      image(flower5, x + 2330, y - 100, w, h);
      image(flower5, x + 7865, y - 400, w, h);
      image(flower5, x + 77330, y - 30, w, h);
      image(flower5, x + 5525, y -130, w, h);
      image(flower5, x + 8655, y -130, w, h);
      image(flower5, x + 11975, y - 130, w, h);
      image(flower5, x + 16580, y - 130, w, h);
      image(flower5, x + 14465, y - 130, w, h);
  
      //paddenstoel rood plaatsen
      image(mushroomRed, x + 250, y + 15, w - 30, h - 30);
      image(mushroomRed, x + 620, y + 10, w - 20, h - 20);
      image(mushroomRed, x + 3600, y - 115, w - 30, h - 30);
      image(mushroomRed, x + 6950, y + 10, w - 20, h - 20);
      image(mushroomRed, x + 17700, y - 115, w - 20, h - 20);
      image(mushroomRed, x + 13755, y - 125, w - 10, h - 10);
  
      //paddenstoel geel plaatsen
      image(mushroomYellow, x + 17640, y - 115, w - 10, h - 10);
      image(mushroomYellow, x + 5165, y - 115, w - 10, h - 10);
      image(mushroomYellow, x + 15840, y - 125, w - 10, h - 10);
  
      //paddenstoel blauw plaatsen
      image(mushroomBlue, x + 7000, y + 15, w - 30, h - 30);
      image(mushroomBlue, x + 3000, y - 665, w - 30, h - 30);
      image(mushroomBlue, x + 17680, y - 115, w - 30, h - 30);
      image(mushroomBlue, x + 13100, y - 125, w - 10, h - 10);
  
      //paddenstoel groen plaatsen
      image(mushroomGreen, x + 580, y + 15, w - 30, h - 30);
      image(mushroomGreen, x + 1435, y - 345, w - 30, w - 30);
    }
  
     public void update()
    {
      xCloud1 ++;
      xCloud2 += 0.5f;
      xCloud3 += 0.3f;
    }
  }

class Bear extends Enemy
{
  PImage bearLeft;
  PImage bearRight;


  Bear() {
    //ervoor zorgen dat de init uitgevoerd wordt
    init();
  }
  
   public void init()
  {
    //initialiseren variabelen
    bearLeft = loadImage("Bear_standing_left.png");
    bearRight = loadImage("Bear_standing_right.png");
    bearLeft.resize(300, 300);
    bearRight.resize(300, 300);
  }

   public void update()
  {
    draw();
    move();
  }
   public void draw()
  {

    super.draw();
    println(vx);
    //Als de beer naar Links loopt
    if (vx<=0)
    {
      //de beer zichtbaar maken
      image(bearLeft, x+70, y+120);
    }
    //als de beer naar links loopt
    if (vx>0)
    {
      image(bearRight, x+50, y+120);
    }
  }
   public void move()
  {
    //beweging regelen
    x+= vx*2;
  }
}

class Bee extends Enemy
{
  PImage beeLeft;
  PImage beeRight;
  float a;
  

  Bee() {
    // ervoor zorgen dat de init uitgevoerd wordt
    init();
  }
  
   public void init()
  {
    //initialiseren variabelen
    beeLeft = loadImage("BeeLeft.png");
    beeRight = loadImage("BeeRight.png");
    beeLeft.resize(100, 100);
    beeRight.resize(100, 100);
  }

   public void update()
  {
    draw();
    move();
  }
   public void draw()
  {
    super.draw();
    println(vx);
    //als de beer naar links loopt
    if (vx<=0)
    {
      image(beeLeft, x+70, y+120);
      
    }
    //als de beer naar rechts loopt
    if (vx>0)
    {
      image(beeRight, x+50, y+120);
      
    }
  }
   public void move()
  {
    //beweging regelen
    x+= vx*3;
    //golfbeweging
    y += sin(0.2f * x * 10);
  }
}

  class Camera {
    PVector pos;
  
    Camera() {
      pos = new PVector(0, 0);
    }
  
     public void draw() {
      //startscherm, zorgt er voor dat de camera niet beweegt
      if (gameState == START_SCREEN) {
        pos.x += 0;
        pos.y += 0;
      } else {
        //zorg er voor dat de camera de speler horizontaal volgt 
        int camOffset = 200;
        //camera volgt de speler naar rechts
        if (player.x <= (pos.x + width / 2) - camOffset) pos.x -= player.speed;
        //camera volgt de speler naar links
        if (player.x >= (pos.x + width / 2) + camOffset) pos.x += player.speed;
  
        //als de speler te ver weg is beweegt de camera sneller naar de speler toe
        if (player.x <= (pos.x + width / 2) - camOffset*2) pos.x -= 100;
        if (player.x >= (pos.x + width / 2) + camOffset*2) pos.x += 1000;
  
        //zorg er voor dat de camera de speler verticaal volgt 
        pos.y = (player.y + 200) - height / 2;
        if (player.y + 200 <= (pos.y + height / 2)) pos.y -= 10;
        if (player.y >= (pos.y + height / 2) - 400) pos.y += 10;
  
        //Zorgt er voor dat de camera stopt als deze voorbij het level gaat
        if (pos.x <= 0) pos.x = 0;
        if (pos.y + height >= height) pos.y = 0;
  
        //lvl 1 cap
        if (lvl == 1 && pos.x + width >= 19000) pos.x = 19000 - width;
  
        //lvl 2 cap
        if (lvl == 2 && pos.x <= 20000) pos.x = 20000;
        if (lvl == 2 && pos.x >= 40000) pos.x = 40000 - width;
  
        //min camera hoogte lvl 2
        if (lvl == 2 && pos.y + height >= 0) pos.y = 0 - height;  
  
        //lvl 3 cap
        if (lvl == 3 && pos.x <= 40500) pos.x = 40500;
        if (lvl == 3 && pos.x >= lvlSize) pos.x = lvlSize - width;
  
        //reset de camera als het level gereset wordt
        if (keysPressed['R']) {
          pos.x = player.x;
          pos.y = player.y;
        }
      }
    }
  }
 
  class Clouds
  {
    //declareren van de variabelen
    float x, y, w, h;
    float vx, vy;
    float diameter;
    int fillColor;
    PImage cloud1;
    PImage cloud2;
    PImage cloud3;
    int cloud;
    PImage loadCloud;
  
     public void init()
    {
      // diameter && kleur
      diameter = random(4) + 5;
      noStroke();
      fillColor = color(0, 0, 255);
      cloud1 = loadImage("wolk1.png");
      cloud2 = loadImage("wolk2.png");
      cloud3 = loadImage("wolk3.png");
      
      cloud = (int)random(1, 3);
      if (cloud == 1)
      {
        loadCloud = cloud1;
      }
      if (cloud == 2)
      {
        loadCloud = cloud2;
      }
      if (cloud == 3)
      {
        loadCloud = cloud3;
      }
  
      // random positie in het scherm
      x = random(0, 20000);
      y = random(-2000, 500);
      w = 200;
      h = 200;
  
      // the velocity and direction of the Clouds
      vx = random(1, 3);
      vy = 0;
    }
  
     public void update()
    {
      x += vx;
      y += vy;
      while ( y > 20000)
      {
        init();
      }
    }
     public void draw() 
    {
      fill(fillColor);
      image(loadCloud, x, y, w, h);
    }
  }
 
   public float calculate1DOverlap(float p0, float p1, float d0, float d1) 
  {
    float dl = p0 + d0 - p1;
    int score = 0;
    float dr = p1 + d1 - p0;  
    return (dr < 0 || dl < 0) ? 0 : (dr >= dl) ? -dl : dr;
  }
  
   public void resolvePlayerPlatformCollision(Platform platform, Player aPlayer) 
  {
    float xOverlap = calculate1DOverlap(aPlayer.x, platform.x, aPlayer.w, platform.w);
    float yOverlap = calculate1DOverlap(aPlayer.y, platform.y, aPlayer.h, platform.h);
  
    if (abs(xOverlap) > 0 && abs(yOverlap) > 0) 
    {
      if (abs(xOverlap) > abs(yOverlap)) 
      {
        player.jumping = false;
        aPlayer.y += yOverlap;
        player.valsnelheid++;
        player.jumpup -= 1;
      } 
      else 
      {        
        player.jumping = false;
        aPlayer.x += xOverlap;
        player.valsnelheid++;
      }
    }
    if (!(abs(xOverlap) > 0 && abs(yOverlap)>0)) 
    {
      player.valsnelheid = 0;
    }
    else 
    {
      player.valsnelheid = 10;
    }
  }
   public void resolvePlayerNutCollision(Nut nut, Player aPlayer) 
  {
    float xOverlap = calculate1DOverlap(aPlayer.x, nut.x, aPlayer.w, nut.w);
    float yOverlap = calculate1DOverlap(aPlayer.y, nut.y, aPlayer.h, nut.h);
  
    if (abs(xOverlap) > 0 && abs(yOverlap) > 0) {
      if (abs(xOverlap) > abs(yOverlap)) {
        // Bij collision verplaatst het juiste nootje naar een positie buiten het speelveld
        nut.x = 99999;
        nut.y = 99999; 
        nutsLeft--;
        sampleBank.trigger("playerNutCollision.wav");
      } else {        
        // Bij collision veplaatst het juiste nootje naar een positie buiten het speelveld
        nut.x = 99999;
        nut.y = 99999;
        nutsLeft--;
        sampleBank.trigger("playerNutCollision.wav");
      }
    }
    if (!(abs(xOverlap) > 0 && abs(yOverlap)>0)) {
      // Doe niks als er geen collision is
    }
  }
   public void resolvePlayerEnemyCollision(Enemy enemy, Player aPlayer) 
  {
    float xOverlap = calculate1DOverlap(aPlayer.x, enemy.x, aPlayer.w, enemy.w);
    float yOverlap = calculate1DOverlap(aPlayer.y, enemy.y, aPlayer.h, enemy.h);
  
    if (abs(xOverlap) > 0 && abs(yOverlap) > 0) 
    {
      if (abs(xOverlap) > abs(yOverlap)) 
      {
        if (player.x != player.startX) 
        {
        }
        sampleBank.trigger("PlayerJumpingOnHead.wav");
        enemy.x = enemy.x + 100000;
        player.jumpup = -17;
      } 
      else 
      {   
  
        player.x = player.startX;
        player.y = player.startY;
        sampleBank.trigger("Buzzer Sound Effect.wav");
      }
    }
  }
   public void resolvePlatformEnemyCollision(Enemy enemy, Platform platform) 
  {
    float xOverlap = calculate1DOverlap(platform.x, enemy.x, platform.w, enemy.w);
    float yOverlap = calculate1DOverlap(platform.y, enemy.y, platform.h, enemy.h);
  
    if (abs(xOverlap) > 0 && abs(yOverlap) > 0) 
    {
      if (abs(xOverlap) > abs(yOverlap)) 
      {
        enemy.vx *= -1;
      } else 
      {        
  
        enemy.vx *= -1;
      }
    }
  }
   public void resolvePlayerFinishCollision(Finish finish, Player aPlayer) {
  
    if (nutsLeft == 0) {
      float xOverlap = calculate1DOverlap(aPlayer.x, finish.x, aPlayer.w, finish.w);
      float yOverlap = calculate1DOverlap(aPlayer.y, finish.y, aPlayer.h, finish.h);
  
      if (abs(xOverlap) > 0 && abs(yOverlap) > 0) {
        if (abs(xOverlap) > abs(yOverlap)) {
          if (lvl == 1) {
            //aangeven dat de speler op de finish staat
            onFinish = true;
  
  
  
            //de speler naar lvl 2 sturen als hij op de finish staat en op s drukt
            if (onFinish == true && keysPressed['S']) 
            {
              //speler positie zetten
              sampleBank.trigger("Ding Sound Effect.wav");
              player.x = 20500;
              player.y = -800;
  
  
              //aangeven dat de speler niet meer op de finish staat
              onFinish = false;
  
              //lvl nummer op 2 zetten (voor restart en voor spawns van noten)
              lvl = 2;
  
              //nootjes voor level 2 spawnen
              nuts[0].init(23150, -900);
              nuts[1].init(26850, -450);
              nuts[2].init(24150, -2400);
              nuts[3].init(21250, -2810);
              nuts[4].init(26500, -3750);
              nuts[5].init(24450, -4450);
              nuts[6].init(21000, -4950);
              nuts[7].init(26650, -1550);
              nuts[8].init(25250, -5750);
              nuts[9].init(29200, -5850);
              nutsLeft = nuts.length;
              typeyourname.textbox = 0;
            }
          } 
          else 
          {
            //aangeven dat de speler op de finish staat
            onFinish = true;
          }
        } 
        else 
        {  
          if (lvl == 1) {
            //aangeven dat de speler op de finish staat
            onFinish = true;
  
  
            //de speler naar lvl 2 sturen als hij op de finish staat en op a drukt
            if (onFinish == true && keysPressed['S']) {
              //speler positie zetten
              player.x = 20500;
              player.y = -800;
  
              //aangeven dat de speler niet meer op de finish staat
              onFinish = false;
  
              //lvl nummer op 2 zetten (voor restart en voor spawns van noten)
              lvl = 2;
  
              //nootjes voor level 2 spawnen
              nuts[0].init(23150, -900);
              nuts[1].init(26850, -450);
              nuts[2].init(24150, -2400);
              nuts[3].init(21250, -2810);
              nuts[4].init(26500, -3750);
              nuts[5].init(24450, -4450);
              nuts[6].init(21000, -4950);
              nuts[7].init(26650, -1550);
              nuts[8].init(25250, -5750);
              nuts[9].init(29200, -5850);
              nutsLeft = nuts.length;
              typeyourname.textbox = 0;
            }
          } 
          else 
          {
            //aangeven dat de speler op de finish staat
            onFinish = true;
          }
        }
        if (!(abs(xOverlap) > 0 && abs(yOverlap)>0)) 
        {
          player.valsnelheid = 0;
        } 
        else 
        {
          player.valsnelheid = 10;
        }
      }
    }
  }

class Enemy {

  //  Enemy()
  //    { 
  //declareren variabelen
  protected float x, vx;
  protected double hsp;
  protected boolean facingLeft;
  protected float w, h;
  protected float y;
  //}

   public void setup()
  {
  }
   public void init(float newX, float newY, float newW, float newH)
  {
    //initialiseren variabelen
    vx = -1;
    facingLeft = true;
    x = newX;
    w = newW;
    h = newH;
    y = newY;
  }
   public void draw()
  {
    imageMode(CENTER);
  }

   public void update()
  { 
    draw();
  }
}
 
  boolean [] lastFrameKeysPressed = new boolean[256];
  boolean [] keysPressed = new boolean[256];
  
   public void updateKeys() 
  {
    for (int iKey = 0; iKey<keysPressed.length; iKey++)
      lastFrameKeysPressed[iKey] = keysPressed[iKey];
  }
  
   public void keyPressed() 
  {
    keysPressed[keyCode] = true;
  }
  
   public void keyReleased() 
  {
    keysPressed[keyCode] = false;
    if (key == 'h') 
    {
      typeyourname.textbox=1;
    }
  }

  class Nut 
  { 
    float x;
    float y;
    float h;
    float w;
  
    PImage nootje;
  
     public void init(int newX, int newY)
    {
      w = 50;
      h = 50;
      x = newX;
      y = newY;
      nootje = loadImage("nootje.png");
    }
  
     public void update()
    {
    }
  
     public void draw()
    {
      image(nootje, x, y + 100, w, h);
    }
  }

  class Platform { 
    
    float x;
    float y;
    float h;
    float w;
    float platformType;
    PImage groundPlatform;
    PImage groundPlatform2;
    PImage groundPlatform3;
    PImage floatingPlatform;
    PImage treePlatform;
    
     public void setup()
    {
    }
  
     public void init(float newPlatformType, float newX, float newY, float newW, float newH)
    {
      w = newW;
      h = newH;
      x = newX;
      y = newY;
      platformType = newPlatformType;
      floatingPlatform = loadImage("platform.png");
      floatingPlatform.resize(3000, 100);
      groundPlatform = loadImage("stone1.png");
      groundPlatform2 = loadImage("ground2.png");
      groundPlatform3 = loadImage("grond.png");
      treePlatform = loadImage("platform_boom.png");
    }
     public void update()
    {
      draw();
    }
     public void draw()
    {
      if (platformType == 0) {
        noStroke();
        fill(0, 255, 0);
        rect(x, y, w, h);
      }
  
      if (platformType == 1) {
        image(floatingPlatform, x + 300, y + 30, w + 50, h + 40);
      }
      if ( platformType == 2)
      {
        image(floatingPlatform, x + 100, y + 30, w + 50, h + 40);
      }
  
      if (platformType == 3) {
  
        image(floatingPlatform, x, y);
        //fill(0);
        //rect(x,y,w,h);
      }
      if (platformType == 4)
      {
        image(treePlatform, x + 95, y + 170, w + 100, h - 130);
      }
      if (platformType == 5)
      {
        image(treePlatform, x + 70, y + 260, w + 100, h - 270);
      }
      if (platformType == 6)
      {
        image(treePlatform, x, y, w, h);
      }
  
      //zwevende platformen lvl 2 en bomen
      if (platformType == 7)
      {
        image(floatingPlatform, x + 150, y + 40, w + 20, h + 40);
      }
      if (platformType == 8)
      {
        image(floatingPlatform, x + 310, y + 40, w + 40, h + 40);
      }
      if (platformType == 9)
      {
        image(floatingPlatform, x + 250, y + 40, w + 20, h + 40);
      }
      if (platformType == 10)
      {
        image(floatingPlatform, x + 100, y + 40, w + 20, h + 40);
      }
      if (platformType == 11)
      {
        image(floatingPlatform, x + 200, y + 40, w + 10, h + 40);
      }
      if (platformType == 12)
      {
        image(treePlatform, x + 20, y + 200, w + 10, h);
      }
      if (platformType == 13)
      {
        image(groundPlatform, x + 75, y + 50, w, h - 200);
      }
      if (platformType == 14)
      {
        image(treePlatform, x + 75, y + 140, w + 10, h);
      }
      if (platformType == 15)
      {
        image(treePlatform, x + 100, y + 200, w + 10, h-200);
      }
  
      //grond
      if (platformType == 16)
      {
        fill(0, 255, 0);
        rect(x, y, w, h);
        fill(139, 69, 19);
        rect(x, y+35, w, h);
      }
    }
  }
 
  class Player {
  
    PImage playerLeft;
    PImage playerRight;
    PImage playerLeft90;
    PImage playerRight90;
    int speed = 15;
    float x, y, vy, vx;
    float jumpup;
    int h, w;
    boolean jumping;
    boolean facingRight;
    int valsnelheid;
    float startX, startY;
  
     public void setup()
    {
    }
  
     public void init()
    {
      valsnelheid = 8; 
      vx = 0;
      vy = 1;
      h = 200;
      w = 200;
      x = startX;
      playerLeft = loadImage("Squirrel_standing_left.png");
      playerRight = loadImage("Squirrel_standing_right.png");
      playerLeft90 = loadImage("Squirrel_standing_left90.png");
      playerRight90 = loadImage("Squirrel_standing_right90.png");
      facingRight = true;
    }
  
     public void draw() {
  
      if (lvl == 1) {
        startX = 300;
        startY = height/2;
      }
      if (lvl == 2) {
        startX = 20200;
        startY = -400;
      }
      if (lvl == 3) {
        startX = 300;
        startY = height/2;
      }
  
      imageMode(CENTER);
      if ( facingRight == true)
      {
        if (rotating == true)
        {
          pushMatrix();
          scale(1, -1);
          image(playerRight90, x+100, y+100, w, h);
          popMatrix();
        } else
        {
          image(playerRight, x+100, y+100, w, h);
        }
      } else
      {
        if (rotating == true)
        {
          image(playerLeft90, x+100, y+100, w, h);
        } else
        {
          image(playerLeft, x+100, y+100, w, h);
        }
      }
  
      if (lvl == 2 && y >= 0) {
        x = startX;
        y = startY;
      }
      if (x == 42000)
      {
        textSize(30);
        text("You win", 400, 600);
      }
    }
  
     public void update() {
      move();
      draw();
      keyPressed();
      keyReleased();
    }
  
     public void move() {
      {
        if (keysPressed['A']) 
        {
          vx-=speed;
          facingRight = false;
        }
        if (keysPressed['D'])
        {
          vx+=speed;
          facingRight = true;
        }
        // toets voor het naar beneden bewegen van de speler, moet verwijderd worden in de inleverversie
        if (keysPressed['S'])  
        {
          vy+=speed;
        }
        // zorgt dat de speler niet eindeloos kan springen door 'w'ingedrukt te houden en zorgt dat de springfunctie alleen gebruikt kan worden als de speler op de grond staat
        if (keysPressed['W'] && !jumping)   
        {
          jumping = true;
          jumpup = -17;
        }
      }
  
      if (jumping == true) {
        y = y + jumpup;
        jumpup = jumpup + 1;
      }
       
      //valsnelheid van de eekhoorn
      vy *=0.9f;  
      vy += valsnelheid;                           
      y += vy;
      x += vx;
  
      //Zorgt ervoor dat de speler niet van het scherma af kan lopen
      if (lvl == 1) {
        x = constrain(x, 0, 18900);
      }
      if (lvl == 2) {
        x = constrain(x, 20000, 40000);
      }
      if (lvl == 3) {
        x = constrain(x, 40500, lvlSize - 100);
      }
      y = constrain(y, -9001, height);
  
      vx = 0;
      vy = 0;
    }
  }
  

  class Restart {
     public void init() {
    }
     public void draw() {
      if (keysPressed['R']) {
        lvl = 1;
        player.x = player.startX;
        player.y = player.startY;
        player.speed = 15;
        time.minutes = 0;
        time.seconds = 0;
        time.tenth = 0;
        time.points = time.startNumberOfPoints;
        nuts[0].init(1600, 150);
        nuts[1].init(2600, 200);
        nuts[2].init(3600, 350);
        nuts[3].init(4700, 0);
        nuts[4].init(7190, -250);
        nuts[5].init(10500, 350);
        nuts[6].init(11700, -750);
        nuts[7].init(13400, -750);
        nuts[8].init(15580, 50);
        nuts[9].init(17700, 350);
        nutsLeft = nuts.length;
        typeyourname.textbox = 0;
        onFinish = false;
   
     for (int i = 0 ; i<Bees.length; i++)
     {
     Bees[i] = new Bee();
     }
      Bees[0].init(2000, height-320, 120, 230);
      Bees[1].init(8000, height-320, 120, 230);
      Bees[2].init(6200, height-320, 120, 230);
      Bees[3].init(10150, height-450, 120, 230);
      Bees[4].init(13500, height-450, 120, 230);
      Bees[5].init(15000, height-450, 120, 230);
      Bees[6].init(16000, height-450, 120, 230);
        
     for (int i = 0; i < Bears.length; i++)
        if (Bears[i].x >= 100000)
        Bears[0].init(2800, height-320, 120, 230);
        Bears[1].init(8000, height-320, 120, 230);
        Bears[2].init(6200, height-320, 120, 230);
        Bears[3].init(10150, height-450, 120, 230);
        Bears[4].init(13500, height-450, 120, 230);
        Bears[5].init(15000, height-450, 120, 230);
        Bears[6].init(16000, height-450, 120, 230);
      }
    }
  }
 
  
  
  // A single score
  class Score {
    // has the name of the player
    String name;
    // and his/her score
    int score;
    String time;
    // Constructor
    Score(String name, int score, String time) {
      this.name = name;
      this.score = score;
      this.time = time;
    }
  }
  
  // ScoreList class manages a list of scores
  class ScoreList {
    ArrayList<Score> scores = new ArrayList<Score>();
    Table scoreTable;
  
    // Constructor
    ScoreList() {
      scoreTable = new Table();
      scoreTable.addColumn("name");
      scoreTable.addColumn("score");
      scoreTable.addColumn("Time");
    }
  
    // Create a new Score and add it to the scores ArrayList
     public void addScore(String name, int score, String time) {
      // Add a new score object to the scores ArrayList
      scores.add(new Score(name, score, time));
      // Sort the scores ArrayList after each score is added
      sortScores();
    }
  
    // return amount of scores in scores ArrayList 
     public int getScoreCount() {
      return scores.size();
    }
  
    // return the score at iScore
     public Score getScore(int iScore) {
      return scores.get(iScore);
    }
  
    // Sort the scores ArrayList
     public void sortScores() {  
      Collections.sort(scores, new HSComperator());
    }
  
    // Save scores to file named "scoreFileName"
     public void save(String scoreFileName) {
      // Copy scores from ArrayList to table
      for (Score score : scores) {
        TableRow row = scoreTable.addRow();
        row.setString("name", score.name);
        row.setInt("score", score.score);
        row.setString("time", score.time);
      }
  
      // save the table to file
      saveTable(scoreTable, scoreFileName);
    }
  
  
    // Load scores from file called "scoreFileName"
     public void load(String scoreFileName) {
  
      // Load the scores into the Table object
      scoreTable = loadTable(scoreFileName, "header");
  
      // copy scores from table to the scores array
      for (int iScore=0; iScore<scoreTable.getRowCount (); iScore++) {
        TableRow row = scoreTable.getRow(iScore);
        scores.add(new Score(row.getString("name"), row.getInt("score"), row.getString("time")));
      }
    }
  }
  
  
  // Comperator class is needed in order for processing to know how
  // to sort a list of scores
  class HSComperator implements Comparator<Score> {
    @Override
      public int compare(Score o1, Score o2) {
      return o2.score - o1.score;
    }
  }
  
  class TypeYourName {
    char startInitial1, initial1, initial2, initial3;
    String stringInitial1, stringInitial2, stringInitial3;
    int textbox;
    float underscoreX, underscoreY;
     public void init() {
      textbox = 0;
      initial1 = 'A';
  
      initial2 = 'A';
      initial3 = 'A';
      underscoreX= width/2+169;
      underscoreY = 155;
    }
     public void draw() {
      if (nutsLeft == 0) {
        if (textbox >0) {
          text("Press [W] to choose and [D] to confirm initials, then hold [S] to see Scores!", width/2-500, 100);
          if (textbox == 1) {
            if (keysPressed['W'] && initial1 != 'Z') {
              initial1++;
              keysPressed['W'] = false;
            }
            if (keysPressed['W'] && initial1 == 'Z') {
              initial1 = 'A';
              keysPressed['W'] = false;
            }
            if (keysPressed['D']) {
              textbox++;
              underscoreX +=19;
              keysPressed['D'] = false;
            }
          }
  
          if (textbox == 2) {
            if (keysPressed['W'] && initial2 != 'Z' ) {
              initial2++;
              keysPressed['W'] = false;
            }
            if (keysPressed['W'] && initial2 == 'Z') {
              initial2 = 'A';
              keysPressed['W'] = false;
            }
            if (keysPressed['D']) {
              textbox++;
              underscoreX +=19;
              keysPressed['D'] = false;
            }
          }
          if (textbox == 3) {
            if (keysPressed['W'] && initial3 != 'Z' ) {
              initial3++;
              keysPressed['W'] = false;
            }
            if (keysPressed['W'] && initial3 == 'Z') {
              initial3 = 'A';
              keysPressed['W'] = false;
            }
  
  
            switch(initial1) {
            case 'A':  
              stringInitial1 = "A";
              break;
            case 'B':  
              stringInitial1 = "B";
              break;
            case 'C':  
              stringInitial1 = "C";
              break;
            case 'D':  
              stringInitial1 = "D";
              break;
            case 'E':  
              stringInitial1 = "E";
              break;
            case 'F':  
              stringInitial1 = "F";
              break;
            case 'G':  
              stringInitial1 = "G";
              break;
            case 'H':  
              stringInitial1 = "H";
              break;
            case 'I':  
              stringInitial1 = "I";
              break;
            case 'J':  
              stringInitial1 = "J";
              break;
            case 'K':  
              stringInitial1 = "K";
              break;
            case 'L':  
              stringInitial1 = "L";
              break;
            case 'M':  
              stringInitial1 = "M";
              break;
            case 'N':  
              stringInitial1 = "N";
              break;
            case 'O':  
              stringInitial1 = "O";
              break;
            case 'P':  
              stringInitial1 = "P";
              break;
            case 'Q':  
              stringInitial1 = "Q";
              break;
            case 'R':  
              stringInitial1 = "R";
              break;
            case 'S':  
              stringInitial1 = "S";
              break;
            case 'T':  
              stringInitial1 = "T";
              break;
            case 'U':  
              stringInitial1 = "U";
              break;
            case 'V':  
              stringInitial1 = "V";
              break;
            case 'W':  
              stringInitial1 = "W";
              break;
            case 'X':  
              stringInitial1 = "X";
              break;
            case 'Y':  
              stringInitial1 = "Y";
              break;
            case 'Z':  
              stringInitial1 = "Z";
              break;
            }
            switch(initial2) {
            case 'A':  
              stringInitial2 = "A";
              break;
            case 'B':  
              stringInitial2 = "B";
              break;
            case 'C':  
              stringInitial2 = "C";
              break;
            case 'D':  
              stringInitial2 = "D";
              break;
            case 'E':  
              stringInitial2 = "E";
              break;
            case 'F':  
              stringInitial2 = "F";
              break;
            case 'G':  
              stringInitial2 = "G";
              break;
            case 'H':  
              stringInitial2 = "H";
              break;
            case 'I':  
              stringInitial2 = "I";
              break;
            case 'J':  
              stringInitial2 = "J";
              break;
            case 'K':  
              stringInitial2 = "K";
              break;
            case 'L':  
              stringInitial2 = "L";
              break;
            case 'M':  
              stringInitial2 = "M";
              break;
            case 'N':  
              stringInitial2 = "N";
              break;
            case 'O':  
              stringInitial2 = "O";
              break;
            case 'P':  
              stringInitial2 = "P";
              break;
            case 'Q':  
              stringInitial2 = "Q";
              break;
            case 'R':  
              stringInitial2 = "R";
              break;
            case 'S':  
              stringInitial2 = "S";
              break;
            case 'T':  
              stringInitial2 = "T";
              break;
            case 'U':  
              stringInitial2 = "U";
              break;
            case 'V':  
              stringInitial2 = "V";
              break;
            case 'W':  
              stringInitial2 = "W";
              break;
            case 'X':  
              stringInitial2 = "X";
              break;
            case 'Y':  
              stringInitial2 = "Y";
              break;
            case 'Z':  
              stringInitial2 = "Z";
              break;
            }
            switch(initial3) {
            case 'A':  
              stringInitial3 = "A";
              break;
            case 'B':  
              stringInitial3 = "B";
              break;
            case 'C':  
              stringInitial3 = "C";
              break;
            case 'D':  
              stringInitial3 = "D";
              break;
            case 'E':  
              stringInitial3 = "E";
              break;
            case 'F':  
              stringInitial3 = "F";
              break;
            case 'G':  
              stringInitial3 = "G";
              break;
            case 'H':  
              stringInitial3 = "H";
              break;
            case 'I':  
              stringInitial3 = "I";
              break;
            case 'J':  
              stringInitial3 = "J";
              break;
            case 'K':  
              stringInitial3 = "K";
              break;
            case 'L':  
              stringInitial3 = "L";
              break;
            case 'M':  
              stringInitial3 = "M";
              break;
            case 'N':  
              stringInitial3 = "N";
              break;
            case 'O':  
              stringInitial3 = "O";
              break;
            case 'P':  
              stringInitial3 = "P";
              break;
            case 'Q':  
              stringInitial3 = "Q";
              break;
            case 'R':  
              stringInitial3 = "R";
              break;
            case 'S':  
              stringInitial3 = "S";
              break;
            case 'T':  
              stringInitial3 = "T";
              break;
            case 'U':  
              stringInitial3 = "U";
              break;
            case 'V':  
              stringInitial3 = "V";
              break;
            case 'W':  
              stringInitial3 = "W";
              break;
            case 'X':  
              stringInitial3 = "X";
              break;
            case 'Y':  
              stringInitial3 = "Y";
              break;
            case 'Z':  
              stringInitial3 = "Z";
              break;
            }
            if (keysPressed['S']) {
              highscores.addScore(stringInitial1 + stringInitial2 + stringInitial3, time.points, time.theTime);
              keysPressed['S'] = false;
              textbox++;
              underscoreX = width/2+169;
            }
          }
  
  
          text("Enter Initials: " + initial1 + "" + initial2 + "" + initial3, width/2, 150);
          text("_", underscoreX, underscoreY);
        }
      }
    }
  }
  
  class StartScreen {
    PImage mainmenu;
    PImage select;
    PImage start;
    PImage stop;
    PImage bord;
    boolean mainMenu;
    int ellipsePosY;
    int x, y;
    int sizeX, sizeY;
  
     public void init() {
      mainMenu = true;
      mainmenu = loadImage("squirrelsvsbearslogo.png");
      select = loadImage("nootjeVleugels.png");
      start = loadImage("startknop.png");
      stop = loadImage("stopknop.png");
      bord = loadImage("bord1.png");
      ellipsePosY = 330;
      x = 0;
      y = 0;
      sizeX = 0;
      sizeY = 0;
    } 
     public void updateAndDraw() {
  
      imageMode(CORNER);
      noStroke();
      fill(0, 210, 255);
      rect(worldCamera.pos.x, worldCamera.pos.y, 1920 -sizeX, 720- sizeY);
      image(mainmenu, x +600, y+ 50, 700 - sizeX, 200- sizeY);
      fill(0, 255, 0);
      image(start, x + 720, y +300, 400 -sizeX, 100-sizeY);
      image(stop, x+ 720, y +500, 400-sizeX, 100- sizeY);
      fill(255, 0, 0);
      image(select, x + 660, y + ellipsePosY, 70 - sizeX, 50-sizeY);
      image(bord, 1500, 400, 400, 400);
  
      gameState = 0;
  
      time.seconds = 0;
      time.tenth = 0;
      time.hundredth = 0;
      move();
    }
     public void move ()
    {
      if (keysPressed['W'])
      {
        ellipsePosY = x + 330;
      }
      if (keysPressed['S'])
      {
        ellipsePosY = x + 530;
      }
  
  
      if (keysPressed['D'] && gameState == 0 && ellipsePosY == 330) 
      {
        gameState = 1;
      }
      if (keysPressed['D'] && ellipsePosY == 530)
      {
        exit();
      }
    }
  }
  class GameOverScreen {
    PImage gameOverScreenLost;
    PImage gameOverScreenWon;
     public void init() {
  
      gameOverScreenLost = loadImage("game_over.png");
      gameOverScreenWon = loadImage("game_over_win.png");
    }
     public void updateAndDraw() {
      if (gameState == GAME_OVER_LOST) {
        player.speed = 0;
        image(gameOverScreenLost, player.x, player.y);
      }
      if (gameState == GAME_OVER_WON) {
        imageMode(CORNER);
        player.speed = 0;
  
        image(gameOverScreenWon, worldCamera.pos.x, worldCamera.pos.y);
      }
    }
  }
  
  class PauzeScreen {
    PImage pauzeScherm;
  
     public void init() {
      imageMode(CORNER);
      pauzeScherm = loadImage("pauseScreen.png");
    }
     public void draw () {
      //tekent de image voor pauze in het midden met tekst pause.
      image(pauzeScherm, worldCamera.pos.x+960, worldCamera.pos.y+270);
      textSize(25);
      //zorgt ervoor dat de camera de pause tekst volgt.
      text("Press 'L' to unpause", worldCamera.pos.x+860, worldCamera.pos.y+270);
  
      if (keysPressed['L'] && gameState == 4) {
        gameState = PLAYING;
      }
    }
     public void updateAndDraw() {
    }
  }

  
  
  
  Minim minim = new Minim(this);
  class SampleBank {
    HashMap<String, AudioSample> samples;
    AudioPlayer musicPlayer;
  
  
  
    // Constructor
    SampleBank() {
      samples = new HashMap<String, AudioSample>();
      loadAllSamples();
    }
  
    // load the background music
     public void loadMusic(String musicFileName) {
      musicPlayer = minim.loadFile(musicFileName);
    }
  
    // play the background music
     public void playMusic() {
      musicPlayer.play();
    }
    // make sure the music keeps playing
     public void loopMusic() {
      musicPlayer.loop();
    }
  
    // Add a new sample to the sample bank
     public void add(String sampleFileName) {
      AudioSample sample = minim.loadSample(sampleFileName);
      samples.put(sampleFileName, sample);
    }
  
    // trigger a loaded sample by fileName
     public void trigger(String sampleFileName) {
      if (samples.containsKey(sampleFileName)) 
        samples.get(sampleFileName).trigger();
    }
  
    // trigger a loaded sample by index
     public void trigger(int sampleIndex) {
      Object [] keys = samples.keySet().toArray();
      if ((sampleIndex >= 0) && (sampleIndex < keys.length))
        trigger((String) keys[sampleIndex]);
    }
  
    //load all .wav files in the processing data directory
     public void loadAllSamples() {
      File dataFolder = new File(dataPath(""));
      File [] files = dataFolder.listFiles();
  
      for (File file : files)
        if (file.getName().toLowerCase().endsWith(".wav"))
          add(file.getName());
    }
  }
  
  class Time {
    String theTime;
    int minutes, seconds, tenth, hundredth;
    int zero;
    int startNumberOfPoints, points;
  
     public void setup() {
      minutes = 0;
      seconds = 0;
      tenth = 0;
      hundredth = 0;
      zero = 1;
      startNumberOfPoints = 999999999;
      points = startNumberOfPoints;
    }
  
     public void update() {
  
      if (seconds<10) {                            
        zero = 1;
      } else {
        zero=0;
      }
      if (tenth<10 && frameCount%6 <= 0) {
        tenth++;
        points--;
  
        if (tenth == 10) {          
          seconds++;
          tenth = 0;
  
          // als er 60 seconden verstreken zijn reset seconds naar 0 en telt 1 minuut erbij
          if (seconds == 60) {
            minutes++;
            seconds = 0;
          }
        }
      }
    }
     public void draw() {
      if (zero == 1)
        text("Time: "+ minutes + ":0" + seconds + "." + tenth, 10, 60);
      if (zero==0) {
        text("Time: "+ minutes + ":" + seconds + "." + tenth, 10, 60);
      }
      theTime = (minutes+ ":" + seconds + "." + tenth);
    }
  }
 
  class Finish { 
    float x;
    float y;
    float h;
    float w;
    PImage finishFlag;
    float finishType;
  
  
     public void setup()
    {
    }
  
     public void init(float newFinishType, float newX, float newY, float newW, float newH)
    {
      w = newW;
      h = newH;
      x = newX;
      y = newY;
      finishType = newFinishType;
      finishFlag = loadImage("finishvlag.png");
    }
     public void update()
    {
      draw();
    }
     public void draw()
    {
      if (finishType == 1)
      {
        image(finishFlag, x, y, w + 100, h + 150);
      }
    }
  }
public class movingPlatform extends Platform
{
  
    
  
}
  
  class raindrops
  {
    float x, y;
    float vx, vy;
    float diameter;
    int fillColor;
  
     public void init()
    {
      // diameter && kleur
      diameter = random(4) + 5;
      noStroke();
      fillColor = color(0, 0, 255);
  
      // random positie in het scherm
      x = random(diameter/2, 20000);
      y = -1400;
  
      // the velocity and direction of the raindrops
      vx = 0;
      vy = random(3, 9);
    }
  
     public void update()
    {
      x += vx;
      y += vy;
  
      while ( y > height)
      {
        init();
      }
    }
     public void draw() 
    {
      fill(fillColor);
      ellipse(x, y, diameter, diameter);
    }
  }


  public void settings() { size(1920, 720); }

  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "Code_1_6_1_technocode_Naomi3" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
